//=============================================================================
// WeaponM23.
//=============================================================================
class WeaponM23 extends PhotonWeapon;

var float	mpRecoilStrength;

//
// functions to change ammo types
//
function bool LoadAmmo(int ammoNum)
{
	local class<Ammo> newAmmoClass;
	local Ammo newAmmo;
	local Pawn P;

	if ((ammoNum < 0) || (ammoNum > 2))
		return False;

	P = Pawn(Owner);

	// sorry, only pawns can have weapons
	if (P == None)
		return False;

	newAmmoClass = AmmoNames[ammoNum];

	if (newAmmoClass != None)
	{
		if (newAmmoClass != AmmoName)
		{
			newAmmo = Ammo(P.FindInventoryType(newAmmoClass));
			if (newAmmo == None)
			{
				P.ClientMessage(Sprintf(msgOutOf, newAmmoClass.Default.ItemName));
				return False;
			}
			
			// if we don't have a projectile for this ammo type, then set instant hit
			if (ProjectileNames[ammoNum] == None)
			{
				bInstantHit = True;
				bAutomatic = Default.bAutomatic;
				ShotTime = Default.ShotTime;
				if ( Level.NetMode != NM_Standalone )
				{
					if (HasReloadMod())
						ReloadTime = mpReloadTime * (1.0+ModReloadTime);
					else
						ReloadTime = mpReloadTime;
				}
				else
				{
					if (HasReloadMod())
						ReloadTime = Default.ReloadTime * (1.0+ModReloadTime);
					else
						ReloadTime = Default.ReloadTime;
				}
				FireSound = Default.FireSound;
				ProjectileClass = None;
			}
			else
			{
			AmmoName = newAmmoClass;
			AmmoType = newAmmo;

				// otherwise, set us to fire projectiles
				bInstantHit = False;
				bAutomatic = Default.bAutomatic;
				ShotTime = Default.ShotTime;
				if (HasReloadMod())
					ReloadTime = 2.0 * (1.0+ModReloadTime);
				else
					ReloadTime = 2.0;
				FireSound = Default.FireSound;		// handled by the projectile
				ProjectileClass = ProjectileNames[ammoNum];
				ProjectileSpeed = ProjectileClass.Default.Speed;

				if ( AmmoRedPhoton(newAmmo) != None )
                                	{
                                        bAutomatic = False;
                                        ShotTime = 1.000000;
                                        ReloadCount = 1;
                                        FireSound = Sound'DeusExSounds.Weapons.AssaultGunFire20mm';
                                        }
				if ( AmmoYellowPhoton(newAmmo) != None )
                                        {
                                        bAutomatic = Default.bAutomatic;
                                        ShotTime = Default.ShotTime;
                                        ReloadCount = Default.ReloadCount;
                                        FireSound = Default.FireSound;
                                        }
                                }
			AmmoName = newAmmoClass;
			AmmoType = newAmmo;

			// AlexB had a new sound for 20mm but there's no mechanism for playing alternate sounds per ammo type
			// Same for WP rocket
			if ( Ammo20mm(newAmmo) != None )
				FireSound=Sound'AssaultGunFire20mm';
			else if ( AmmoRocketWP(newAmmo) != None )
				FireSound=Sound'GEPGunFireWP';
			else if ( AmmoRocket(newAmmo) != None )
				FireSound=Sound'GEPGunFire';

			if ( Level.NetMode != NM_Standalone )
				SetClientAmmoParams( bInstantHit, bAutomatic, ShotTime, FireSound, ProjectileClass, ProjectileSpeed );

			// Notify the object belt of the new ammo
			if (DeusExPlayer(P) != None)
				DeusExPlayer(P).UpdateBeltText(Self);

			ReloadAmmo();

			P.ClientMessage(Sprintf(msgNowHas, ItemName, newAmmoClass.Default.ItemName));
			return True;
		}
		else
		{
			P.ClientMessage(Sprintf(MsgAlreadyHas, ItemName, newAmmoClass.Default.ItemName));
		}
	}
	return False;
}

//simulated function SwapMuzzleFlashTexture()
//{
//   	if ( !bHasMuzzleFlash )
//      		return;  
//	
//	MultiSkins[2] = Texture'GoldLaserSpot';
//	SetTimer(0.1, False);
//}

defaultproperties
{
     LowAmmoWaterMark=30
     GoverningSkill=Class'DeusEx.SkillWeaponRifle'
     Concealability=CONC_Visual
     bAutomatic=True
     ShotTime=0.100000
     reloadTime=2.000000
     HitDamage=7
     BaseAccuracy=0.650000
     bHasScope=True
     bCanHaveLaser=True
     bHasLaser=True
     bCanHaveSilencer=True
     AmmoNames(0)=Class'Markistan.AmmoYellowPhoton'
     AmmoNames(1)=Class'Markistan.AmmoRedPhoton'
     ProjectileNames(0)=Class'Markistan.YellowPhotonBlast'
     ProjectileNames(1)=Class'Markistan.RedPhotonShell'
     recoilStrength=0.500000
     MinWeaponAcc=0.200000
     mpReloadTime=2.000000
     mpHitDamage=7
     mpAccurateRange=2400
     mpMaxRange=2400
     mpReloadCount=50
     bCanHaveModRecoilStrength=True
     AmmoName=Class'Markistan.AmmoYellowPhoton'
     ReloadCount=50
     PickupAmmoCount=150
     FireOffset=(X=-16.000000,Y=5.000000,Z=11.500000)
     ProjectileClass=Class'Markistan.YellowPhotonBlast'
     shakemag=200.000000
     FireSound=Sound'Markistan.Weapons.PhotonAssaultRifleFire'
     AltFireSound=Sound'DeusExSounds.Weapons.AssaultGunReloadEnd'
     CockingSound=Sound'DeusExSounds.Weapons.AssaultGunReload'
     SelectSound=Sound'DeusExSounds.Weapons.AssaultGunSelect'
     InventoryGroup=177
     ItemName="|p4M-23 photon assault rifle"
     ItemArticle="an"
     PlayerViewOffset=(X=16.000000,Y=-5.000000,Z=-11.500000)
     PlayerViewMesh=LodMesh'DeusExItems.AssaultGun'
     PickupViewMesh=LodMesh'DeusExItems.AssaultGunPickup'
     ThirdPersonMesh=LodMesh'DeusExItems.AssaultGun3rd'
     LandSound=Sound'DeusExSounds.Generic.DropMediumWeapon'
     Icon=Texture'Markistan.Icons.BeltIconM23'
     largeIcon=Texture'Markistan.Icons.InventoryIconM23'
     largeIconWidth=142
     largeIconHeight=65
     invSlotsX=3
     invSlotsY=2
     Description="Th M-23 photon assault rifle is deadly in the fact that it fires small, but deadly yellow photon blasts and has an attached and devestating red photon grenade launcher."
     beltDescription="|p4M-23"
     Mesh=LodMesh'DeusExItems.AssaultGunPickup'
     CollisionRadius=15.000000
     CollisionHeight=1.100000
     Mass=30.000000
}
